--[[---------------------------------------------------------------------------
	Chocolatier Two Medals
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local function CheckRank(n)
	return (gSim.rank >= n)
end

local function CheckRecipes(type, n)
	local t = LProductType:ByName(type)
	return (t and t.knownCount >= n)
end

local function OwnShop()
	return gSim.shopOwned
end

local function OwnLab()
	return gSim.labOwned
end

local function OwnAllFactories()
	return (gSim.factoriesOwned == 6)
end

local function AllPorts()
	-- All ports visited evaluated elsewhere...
	return false
end

local function InventedRecipe()
	return (gSim.inventCount >= 2)
end

-------------------------------------------------------------------------------
-- Medals list and evaluation

Simulator._Medals =
{
	{ name="novice", x=17,y=70,w=71,h=40, mx=54,my=89, eval=function() return CheckRank(1) end },
	{ name="square", x=68,y=70,w=58,h=41, mx=101,my=87, eval=function() return CheckRecipes("square",6) end },
	{ name="entrep", x=120,y=70,w=58,h=41, mx=145,my=88, eval=function() return CheckRank(2) end },
	{ name="lab", x=159,y=70,w=72,h=40, mx=192,my=88, eval=function() return OwnLab() end },
	{ name="inventor", x=198,y=84,w=57,h=54, mx=224,my=112, eval=function() return InventedRecipe() end },
	{ name="infusion", x=199,y=123,w=57,h=42, mx=228,my=144, eval=function() return CheckRecipes("infusion",7) end },
	{ name="shop", x=190,y=155,w=55,h=45, mx=217,my=172, eval=function() return OwnShop() end },
	{ name="sauce", x=180,y=179,w=53,h=58, mx=204,my=204, eval=function() return CheckRecipes("sauce",9) end },
	{ name="choco", x=144,y=200,w=63,h=41, mx=173,my=220, eval=function() return CheckRank(3) end },
	{ name="praline", x=97,y=200,w=60,h=42, mx=128,my=219, eval=function() return CheckRecipes("praline",10) end },
	{ name="master", x=45,y=200,w=63,h=41, mx=78,my=220, eval=function() return CheckRank(4) end },
	{ name="ports", x=17,y=179,w=53,h=58, mx=43,my=203, eval=function() return AllPorts() end },
	{ name="factory", x=5,y=155,w=56,h=45, mx=33,my=174, eval=function() return OwnAllFactories() end },
	{ name="truffle", x=0,y=123,w=57,h=43, mx=27,my=143, eval=function() return CheckRecipes("truffle",11) end },
	{ name="exotic", x=0,y=81,w=57,h=54, mx=28,my=108, eval=function() return (CheckRecipes("square",12) and CheckRecipes("infusion",12) and CheckRecipes("sauce",12) and CheckRecipes("praline",12) and CheckRecipes("truffle",12) and CheckRecipes("exotic",12)) end },
}

function Simulator:AwardMedal(name)
	gNewMedal = nil
	if not self.medals[name] then
		gNewMedal = name
		self.medals[name] = true
		SetMusicState("normal","music/medal_fanfare.ogg")
		
		-- FIRSTPEEK: Medal, time-stamp, weeks, medal
		if fpWrite then fpWrite { "Medal", gSim.weeks, name } end
	end

	local medal = nil
	for i,m in ipairs(self._Medals) do
		if m.name == name then medal = m break end
	end
	DisplayDialog { "ui/medal_award.lua", medal=medal }
	if gNewMedal then UpdateBadge(self) end
end

function Simulator:EvaluateMedals()
	if self.mode ~= "free" then
		local award = false
		for i,m in ipairs(self._Medals) do
			if not self.medals[m.name] and m.eval() then
				award = true
				self:AwardMedal(m.name)
			end
		end
		
		if award then
			UpdateDynamicContent("badge")
			UpdateBadge(self)
		end
	end
end

-------------------------------------------------------------------------------
-- Medal rollover

function MedalRollover(i)
	local m = Simulator._Medals[i]
	local x = (m.x + m.w/2 - 10)
	local y = (m.y + m.h/2 - 10)
	return Rollover { x=x,y=y, w=20,h=20, hotSize=5,
		contents="DoMedalRollover("..tostring(i)..")",
		command=function() gSim:AwardMedal(m.name) end,
--		Bitmap { image="image/medal_"..tostring(i) }
	}
end

function DoMedalRollover(i)
	local dy = bsgFontHeight(standardFont)
	local m = Simulator._Medals[i]
	local name = GetString("med_"..m.name)
--	local desc = GetString("med_"..m.name.."_desc")
	local r =
	{
		x=0,y=0, color=PopupColor, inset=2,
		AppendStyle { font = popupFont, flags=kHAlignLeft+kVAlignTop },
		TightText { x=0,y=0, label=name },
--		TightText { x=0,y=dy, label=desc },
	}
	return MakeRollover(r)
end
